import React from 'react'

type Props = {
  dark?: boolean
}

const PlusIcon = ({ dark }: Props): React.ReactElement => {
  return (
    <svg
      width="16"
      height="16"
      viewBox="-5 -6 16 16 "
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M6 0H4V4H0V6H4V10H6V6H10V4H6V0Z"
        fill={dark ? '#43414E' : '#999999'}
      />
    </svg>
  )
}

export default PlusIcon
