import React from 'react'
import styled from '@emotion/styled'

type IconProps = {
  disabled?: boolean
}

const StyledPath = styled.path<IconProps>(({ theme, disabled }) => ({
  fill: disabled ? theme.colors.mediumGray : theme.colors.text,
}))

const FolderIcon = ({ disabled }: IconProps): React.ReactElement => (
  <svg
    width="11"
    height="10"
    viewBox="0 0 11 10"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <StyledPath
      d="M6.16817 3.88462L4.19758 2H2V7.5H9V3.88462H6.16817ZM11 1.88462V9.5H0V0H5L6.97059 1.88462H11Z"
      clipRule="evenodd"
      fillRule="evenodd"
      disabled={disabled}
    />
  </svg>
)

export default FolderIcon
