import React from 'react'

import styled from '@emotion/styled'

type ChevronIconProps = {
  className?: string
}

const ChevronIcon = ({ className }: ChevronIconProps): React.ReactElement => (
  <svg
    width="16"
    height="16"
    viewBox="0 0 16 16"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    className={className}
  >
    <path
      d="M5.58594 10.9998L7.00015 12.4141L11.4144 7.99985L7.00015 3.58564L5.58594 4.99985L8.58594 7.99985L5.58594 10.9998Z"
      fill="#999999"
    />
  </svg>
)

const StyledChevronIcon = {
  Up: styled(ChevronIcon)({
    transform: 'rotate(-90deg)',
  }),

  Right: ChevronIcon,

  Down: styled(ChevronIcon)({
    transform: 'rotate(90deg)',
  }),

  Left: styled(ChevronIcon)({
    transform: 'rotate(180deg)',
  }),
}

export default StyledChevronIcon
