import styled from '@emotion/styled'
import React from 'react'

const CheckedIcon = ({ className }): React.ReactElement => (
  <svg
    width="7"
    height="6"
    viewBox="0 0 7 6"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    className={className}
  >
    <path d="M5.48173 0.220459L6.54373 1.27946L2.63548 5.19596L0.219727 2.78021L1.28023 1.71971L2.63398 3.07346L5.48173 0.220459Z" />
  </svg>
)

export default {
  CheckedIcon: styled(CheckedIcon)(({ theme }) => ({
    '& path': {
      fill: theme.colors.primaryText,
    },
  })),
}
