import React from 'react'
import styled from '@emotion/styled'

const StyledPath = styled.path(({ theme }) => ({
  fill: theme.colors.text,
}))

const FileIcon = (): React.ReactElement => (
  <svg
    width="13"
    height="15"
    viewBox="0 0 13 15"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <StyledPath d="M8.48341 0.00317383L12.003 3.5782V14.0118H0V0.00317383H8.48341ZM5.995 2.00217L2 2.00295V12.011H10.003V6.00817L5.99545 6.00898L5.995 2.00217ZM7.995 2.35617V4.00895L9.621 4.00817L7.995 2.35617Z" />
  </svg>
)

export default FileIcon
